unit Talker;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl;

type
  TTalker = class(TComponent)
  private
    FEnabled: boolean;
  protected
  public
    constructor Create(AOwner:TComponent); override;
    Destructor Destroy; override;
    Procedure Talk( AStr: string);
  published
    property Enabled: boolean read FEnabled default False;
  end;

var
 DLLHandel: Word;		{ for the DLL }
 ISCB:LongInt;
 OpenSpeech: function(WH:hwnd; Mode:word; VoiceType:Pchar):LongInt;
 Say: function(SCB:LongInt;OutStr:Pchar):longInt;
 CloseSpeech: function(SCB:LongInt):LongInt;


procedure Register;





implementation


procedure TTalker.Talk( aStr: string );
var
  nts: PChar;
begin
  nts := StrAlloc(Length(aStr)+1);
  StrPCopy( nts, aStr );
  Say( ISCB, nts );
  StrDispose(nts);
end;



{-- Creates the component and sets the defaults }
constructor TTalker.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := False;
  DLLHandel:= LoadLibrary( 'FB_SPCH.DLL' );
  if DLLHandel >= 32 then
   begin
    FEnabled := True;
    @OpenSpeech:= GetProcAddress( DLLHandel, 'OpenSpeech' );
    @Say:= GetProcAddress( DLLHandel, 'Say' );
    @CloseSpeech:= GetProcAddress( DLLHandel, 'CloseSpeech' );
    ISCB:=OpenSpeech(GetActiveWindow,0, nil);
   end;
end;


Destructor TTalker.Destroy;
Begin
  inherited Destroy;
  closeSpeech(ISCB);
  FreeLibrary( DLLHandel );
End;









procedure Register;
begin
  RegisterComponents('Samples', [TTalker]);
end;

end.
